package com.tykj.zspdemo.jwt;

import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author zhoushaopan
 */
public class JwtTokenAuthenticationFilter extends GenericFilterBean {

    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();

    private final JwtTokenProvider jwtTokenProvider;


    public JwtTokenAuthenticationFilter(JwtTokenProvider jwtTokenProvider) {
        this.jwtTokenProvider = jwtTokenProvider;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain)
            throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        String requestUri = request.getRequestURI();
        //放行的路径
//        String[] urls = new String[]{
//                "/user/login","/role/**","/user/insert"
//        };
//        Boolean check = check(urls, requestUri);
//        if (check){
//            //放行
//            System.out.println("check = " + check);
//            filterChain.doFilter(request,response);
//            return;
//        }
        try {
            String token = jwtTokenProvider.resolveToken(request);
            if (token != null && jwtTokenProvider.validateToken(token)) {
                Authentication auth = jwtTokenProvider.getAuthentication(token);
                if (auth != null) {
                    SecurityContextHolder.getContext().setAuthentication(auth);
                }
                //刷新token
            }
//            else {
//                response.setStatus(HttpStatus.UNAUTHORIZED.value());
//                response.getWriter().write("Unauthorized");
//                response.getWriter().flush();
//                return;
//
//            }
        } catch (InvalidJwtAuthenticationException e) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.getWriter().write("Invalid token");
            response.getWriter().flush();
            return;
        }

        filterChain.doFilter(req, res);
    }


    /**
     * 为路径做检验
     * @param urls 需要放行的路径
     * @param requestURI 请求的路径
     * @return true false
     */
    private Boolean check(String[] urls,String requestURI){
//        "/user/login","/role/**","/user/insert"
        for (String url : urls) {
            return PATH_MATCHER.match(url, requestURI);
        }
        return false;
    }

}
