package com.tykj.zspdemo.security;


import com.tykj.zspdemo.subject.entity.Role;
import com.tykj.zspdemo.subject.entity.User;
import com.tykj.zspdemo.subject.entity.UserRole;
import com.tykj.zspdemo.subject.mapper.RoleMapper;
import com.tykj.zspdemo.subject.mapper.UserMapper;
import com.tykj.zspdemo.subject.mapper.UserRoleMapper;
import com.tykj.zspdemo.subject.service.RoleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.lang.reflect.Array;
import java.util.List;
import java.util.stream.Collectors;



/**
 * @author zhoushaopan
 */
@Service
@Slf4j
public class MyUserDetailsServiceImpl implements UserDetailsService {

    @Resource
    private UserMapper userMapper;

    @Resource
    private RoleService roleService;

    @Resource
    private UserRoleMapper userRoleMapper;

    @Override
    public UserDetails loadUserByUsername(String username){
        SecurityUser securityUser = new SecurityUser();
        User user = userMapper.findByUsername(username);
        if (user == null){
            throw new UsernameNotFoundException("该用户不存在");
        }
        Integer userId = user.getId();
        List<UserRole> userRoleList = userRoleMapper.findAllByUserId(userId);
        if (userRoleList.size() >0){
            List<Integer> roleIdList = userRoleList
                    .stream()
                    .map(UserRole::getRoleId)
                    .distinct()
                    .collect(Collectors.toList());
            List<Role> roles = roleService.findAllByIds(roleIdList);
            securityUser.setRoleList(roles);
        }
        securityUser.setUser(user);
        securityUser.setUsername(user.getUsername());
        SecurityContextHolder.getContext().setAuthentication(new UsernamePasswordAuthenticationToken(securityUser, user.getPassword(),
                securityUser.getAuthorities()));
        return securityUser;
    }


}
