package com.tykj.zspdemo.security;


import com.tykj.zspdemo.jwt.ApiAccessDecisionManager;
import com.tykj.zspdemo.jwt.JwtSecurityConfigurer;
import com.tykj.zspdemo.jwt.JwtTokenAuthenticationFilter;
import com.tykj.zspdemo.jwt.JwtTokenProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

import javax.annotation.Resource;


/**
 * @author zsp
 */
@Configuration
@EnableWebSecurity
public class SecurityConfig extends WebSecurityConfigurerAdapter {


    @Resource
    private JwtTokenProvider jwtTokenProvider;

    @Resource
    private MyEntryPoint myEntryPoint;

    @Resource
    private UrlAccessDeniedHandler urlAccessDeniedHandler;

    @Resource
    private ApiAccessDecisionManager apiAccessDecisionManager;

    @Bean
    @Override
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public PasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }


    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.cors().and().csrf().disable()
                .sessionManagement()
                .sessionCreationPolicy(SessionCreationPolicy.STATELESS)
                .and()
                .authorizeRequests().antMatchers(HttpMethod.OPTIONS, "/**").permitAll()
                .antMatchers("/user/login","/role/**","/user/insert").permitAll()
                .accessDecisionManager(accessDecisionManager())
                .anyRequest().authenticated()
                .and()
                .exceptionHandling()
                .authenticationEntryPoint(myEntryPoint)
                .accessDeniedHandler(urlAccessDeniedHandler)
                .and()
//                .apply(new JwtSecurityConfigurer(jwtTokenProvider))
                .addFilterBefore(new JwtTokenAuthenticationFilter(jwtTokenProvider), UsernamePasswordAuthenticationFilter.class);
//                .and();
    }

    @Override
    public void configure(WebSecurity web) {
        //swagger静态资源访问
        web.ignoring().antMatchers("/v2/api-docs", "/v2/api-docs-ext", "/configuration/ui",
                "/swagger-resources/**", "/configuration/security", "/swagger-ui/", "/swagger-ui/**", "" +
                        "/swagger-ui.html", "/doc.html", "/webjars/**", "/swagger-resources/configuration/ui",
                "**/swagger-ui.html", "**/**/index.html", "**/index.html", "/**/index.html", "/js/**",
                "/css/**", "/fonts/**", "/img/**","/access/send","/user/s","/druid/*","/file/**","/fonts/**"
               );
    }

    @Bean
    public AccessDecisionManager accessDecisionManager() {
        // 返回自定义的AccessDecisionManager
        return apiAccessDecisionManager;
    }
}

