package com.tykj.zspdemo.subject.controller;

import com.tykj.zspdemo.subject.entity.MpEntity;
import com.tykj.zspdemo.subject.entity.vo.PageWebVO;
import com.tykj.zspdemo.subject.entity.vo.SelectMpVO;
import com.tykj.zspdemo.subject.entity.vo.SingVO;
import com.tykj.zspdemo.subject.service.MpEntityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author: zsp
 * @create: 2023-08-30 14:20
 **/

@RestController
@RequestMapping("/mpEntity")
@Slf4j
public class MpEntityController {

    @Resource
    private MpEntityService mpEntityService;

    @PostMapping("/insert")
    public void insert(@RequestBody MpEntity mpEntity){
        mpEntityService.insert(mpEntity);
    }

    @PostMapping("/getPage")
    public PageWebVO<MpEntity> getPage(@RequestBody SelectMpVO selectMpVO){
        return mpEntityService.getPage(selectMpVO);
    }

    @PostMapping("/update")
    public void update(@RequestBody MpEntity mpEntity){
        mpEntityService.update(mpEntity);
    }

    @DeleteMapping("/remove")
    public void remove(Integer id){
         mpEntityService.remove(id);
    }


}
