package com.tykj.zspdemo.subject.controller;

import com.tykj.zspdemo.subject.entity.Role;
import com.tykj.zspdemo.subject.entity.User;
import com.tykj.zspdemo.subject.entity.UserRole;
import com.tykj.zspdemo.subject.service.RoleService;
import com.tykj.zspdemo.subject.service.UserRoleService;
import com.tykj.zspdemo.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: zsp
 * @create: 2023-08-31 14:10
 **/
@RestController
@RequestMapping("/role")
@Slf4j
public class RoleController {

    @Resource
    private RoleService roleService;

    @Resource
    private UserRoleService userRoleService;

    @PostMapping("/insert")
    public String insert(@RequestBody Role role){
        roleService.insertRole(role);
        return "新增角色成功";
    }

    @PostMapping("/insertUserRole")
    public String insertUserRole(@RequestBody UserRole userRole){
        userRoleService.insert(userRole);
        return "授权成功";
    }

}
