package com.tykj.zspdemo.subject.controller;

import com.tykj.zspdemo.aop.CountAop;
import com.tykj.zspdemo.security.SecurityUser;
import com.tykj.zspdemo.subject.entity.MpEntity;
import com.tykj.zspdemo.subject.entity.User;
import com.tykj.zspdemo.subject.entity.vo.user.UserVO;
import com.tykj.zspdemo.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: zsp
 * @create: 2023-08-31 14:10
 **/
@RestController
@RequestMapping("/user")
@Slf4j
@CountAop(desc = "用户管理")
public class UserController {

    @Resource
    private UserService userService;

    @PostMapping("/insert")
    public String insert(@RequestBody User user){
        userService.insertUser(user);
        return "success";
    }


    @GetMapping("/selectUserList")
    public List<User> selectUserList(){
        return userService.selectUserList();
    }

    @GetMapping("/findUserById/{id}")
    public User findUserById(@PathVariable("id") Integer id){
        return userService.findUserById(id);
    }

    @PostMapping("/login")
    public SecurityUser login(@RequestBody UserVO userVO){
        return userService.login(userVO);
    }
}
