package com.tykj.zspdemo.subject.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tykj.zspdemo.security.SecurityUser;
import com.tykj.zspdemo.subject.entity.User;
import com.tykj.zspdemo.subject.entity.vo.user.UserVO;

import java.util.List;

/**
 * @author: zsp
 * @create: 2023-08-31 14:01
 **/
public interface UserService extends IService<User> {

    /**
     * 新增用户接口
     * @param user
     */
    void insertUser(User user);

    /**
     *  查询用户列表接口
     * @return
     */
    List<User> selectUserList();

    /**
     * 查询单个用户接口
     * @param id
     * @return
     */
    User findUserById(Integer id);

    /**
     * 登录接口
     * @param userVO
     * @return
     */
    SecurityUser login(UserVO userVO);
}
