package com.tykj.zspdemo.subject.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.zspdemo.subject.entity.KxBaseSingleRecord;
import com.tykj.zspdemo.subject.entity.vo.PageWebVO;
import com.tykj.zspdemo.subject.entity.vo.SingVO;
import com.tykj.zspdemo.subject.mapper.KxBaseSingleRecordMapper;
import com.tykj.zspdemo.subject.service.KxBaseSingleService;
import com.tykj.zspdemo.subject.util.MapToObjectConverter;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author: zsp
 * @create: 2023-08-30 10:31
 **/
@Service
public class KxBaseSingleServiceImpl extends ServiceImpl<KxBaseSingleRecordMapper,KxBaseSingleRecord> implements KxBaseSingleService {

    @Resource
    private KxBaseSingleRecordMapper kxBaseSingleRecordMapper;

    @Override
    public PageWebVO<SingVO> getPage() {
        Page<Map<String, Object>> page = new Page<>(1, 2);
        QueryWrapper<KxBaseSingleRecord> query = new QueryWrapper<>();
        List<String> columns = new ArrayList<>(Arrays.asList("education_base_id","appointment_time"));
        query.groupBy(columns)
                .select("education_base_id","appointment_time","count(appointment_time) as count","sum(sign_in_num) as sign_in_num");
        Page<Map<String, Object>> mapPage = kxBaseSingleRecordMapper.selectMapsPage(page, query);
        List<Map<String, Object>> records = mapPage.getRecords();
        List<SingVO> singleRecords = new ArrayList<>();
        if (records.size() > 0) {
            for (Map<String, Object> map : records) {
                try {
                    SingVO convert = MapToObjectConverter.convert(map, SingVO.class);
                    singleRecords.add(convert);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return new PageWebVO<>(mapPage.getTotal(), mapPage.getPages(), singleRecords);
    }
}
