package com.tykj.zspdemo.subject.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.zspdemo.subject.entity.MpEntity;
import com.tykj.zspdemo.subject.entity.vo.PageWebVO;
import com.tykj.zspdemo.subject.entity.vo.SelectMpVO;
import com.tykj.zspdemo.subject.mapper.MpEntityMapper;
import com.tykj.zspdemo.subject.service.MpEntityService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author: zsp
 * @create: 2023-08-30 14:16
 **/
@Service
public class MpEntityServiceImpl extends ServiceImpl<MpEntityMapper,MpEntity>implements MpEntityService {

    @Resource
    private MpEntityMapper mpEntityMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insert(MpEntity p) {
        mpEntityMapper.insert(p);
    }

    @Override
    public PageWebVO<MpEntity> getPage(SelectMpVO selectMpVO) {
        String mpName = selectMpVO.getMpName();
        QueryWrapper<MpEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(mpName != null, "name", mpName);
        Page<MpEntity> selectPage = mpEntityMapper.selectPage(selectMpVO.getPageable(), queryWrapper);
        return new PageWebVO<>(selectPage.getTotal(),selectPage.getPages(),selectPage.getRecords());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MpEntity mpEntity) {
        mpEntityMapper.updateById(mpEntity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(Integer id) {
        mpEntityMapper.deleteById(id);
    }
}
