package com.tykj.zspdemo.subject.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.zspdemo.subject.entity.Role;
import com.tykj.zspdemo.subject.mapper.RoleMapper;
import com.tykj.zspdemo.subject.service.RoleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: zsp
 * @create: 2023-08-31 14:09
 **/
@Service
public class RoleServiceImpl extends ServiceImpl<RoleMapper, Role> implements RoleService {

    @Resource
    private RoleMapper roleMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insertRole(Role role) {
        roleMapper.insert(role);
    }

    @Override
    public List<Role> findAllByIds(List<Integer> roleIds) {
        QueryWrapper<Role> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id",roleIds);
        return roleMapper.selectList(queryWrapper);
    }
}
