package com.tykj.zspdemo.subject.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.zspdemo.jwt.JwtTokenProvider;
import com.tykj.zspdemo.security.MyUserDetailsServiceImpl;
import com.tykj.zspdemo.security.SecurityUser;
import com.tykj.zspdemo.subject.entity.User;
import com.tykj.zspdemo.subject.entity.vo.user.UserVO;
import com.tykj.zspdemo.subject.mapper.UserMapper;
import com.tykj.zspdemo.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: zsp
 * @create: 2023-08-31 14:06
 **/
@Service
@Slf4j
public class UserServiceImpl extends ServiceImpl<UserMapper,User> implements UserService {


    @Resource
    private UserMapper userMapper;

    @Resource
    private PasswordEncoder passwordEncoder;

    @Resource
    private MyUserDetailsServiceImpl myUserDetailsService;

    @Resource
    private AuthenticationManager authenticationManager;

    @Resource
    private JwtTokenProvider jwtTokenProvider;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insertUser(User user) {
        user.setPassword(passwordEncoder.encode(user.getPassword()));
        userMapper.insert(user);
    }

    @Override
    public List<User> selectUserList() {
        return userMapper.selectList(null);
    }

    @Override
    public User findUserById(Integer id) {
        return userMapper.selectById(id);
    }

    @Override
    public SecurityUser login(UserVO userVO) {
        String username = userVO.getUsername();
        String password = userVO.getPassword();
        SecurityUser securityUser = (SecurityUser) myUserDetailsService.loadUserByUsername(username);
        authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(securityUser, password));
        //生成token
        String token = jwtTokenProvider.createToken(username);
        securityUser.setToken(token);
        return securityUser;
    }
}
