package com.tykj.zspdemo.subject.util;

/**
 * @author: zsp
 * @create: 2023-08-30 11:46
 **/
import org.apache.commons.beanutils.BeanUtils;
import java.util.Map;

public class MapToObjectConverter {
    public static <T> T convert(Map<String, Object> map, Class<T> clazz) throws Exception {
        T obj = clazz.getDeclaredConstructor().newInstance();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String propertyName = convertToCamelCase(entry.getKey());
            BeanUtils.setProperty(obj, propertyName, entry.getValue());
        }
        return obj;
    }

    private static String convertToCamelCase(String input) {
        StringBuilder sb = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
            } else {
                if (capitalizeNext) {
                    sb.append(Character.toUpperCase(c));
                    capitalizeNext = false;
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        return sb.toString();
    }
}

