package com.tykj.zlbapp.subject.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tykj.zlbapp.contants.AppConstants;
import com.tykj.zlbapp.subject.service.ZlbAppAuthService;
import com.tykj.zlbapp.subject.vo.TokenVO;
import com.tykj.zlbapp.util.HeadUtil;
import com.tykj.zlbapp.util.MD5Util;
import com.tykj.zlbapp.util.XMLParse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * @author zsp
 * @version 1.0
 * @date 2022/8/26 10:12
 */
@Service
public class ZlbAppAuthServiceImpl implements ZlbAppAuthService {

    @Resource
    private RestTemplate restTemplate;

    @Override
    public TokenVO getTokenByTicket(String ticket) {
        //请求zlbApp的接口
        //进行接口请求的构造
        //1 构造header
        HttpHeaders headers = HeadUtil.getHeader();
        //请求body为x-www-form-urlencoded方式
        MultiValueMap<String,Object> params = new LinkedMultiValueMap<>();
        //servicecode 就是ak
        params.add("servicecode",AppConstants.IRS_AK);
        params.add("method","ticketValidation");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        String format = simpleDateFormat.format(new Date());
        params.add("time",format);
        params.add("sign", MD5Util.getInstance().getMD5(AppConstants.IRS_AK+AppConstants.IRS_SK+format));
        params.add("st",ticket);
        HttpEntity<MultiValueMap<String, Object>> httpEntity=new HttpEntity<>(params,headers);
        String body = restTemplate.postForEntity(AppConstants.ACCESS_TOKEN_URL, httpEntity, String.class).getBody();
        //解析xml
        Map<String, Object> valueByNode = XMLParse.getValueByNode(body);
        return JSONObject.parseObject(JSONObject.toJSONString(valueByNode), TokenVO.class);
    }
}
