package com.tykj.zlbapp.contants;

/**
 * @author jie.chen
 * @date 2022-03-30 15:24
 */
public interface AppConstants {

    /**
     * 单点登录(app) ticketId换token的地址
     *
     * 互联网 https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220228000002/sso/servlet/simpleauth
     *
//     * 政府外网 https://bcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220329000007/uc/sso/access_token
     */
    String ACCESS_TOKEN_URL = "https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220228000002/sso/servlet/simpleauth";

    /**
     * 单点登录(app) token获取用户信息地址
     * 互联网  https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo
     * 政府外网 https://bcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo
     */
    String GET_USER_INFO_URL = "https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo";

    /**
     * IRS请求携带的请求头
     */
    String X_BG_HMAC_ACCESS_KEY = "X-BG-HMAC-ACCESS-KEY";
    String X_BG_HMAC_SIGNATURE = "X-BG-HMAC-SIGNATURE";
    String X_BG_HMAC_ALGORITHM = "X-BG-HMAC-ALGORITHM";
    String X_BG_DATE_TIME = "X-BG-DATE-TIME";

    /**
     * IRS签名算法
     */
    String DEFAULT_HMAC_SIGNATURE = "hmac-sha256";

    /**
     * 应用ID
     */
    String APP_ID = "lm5p4fkv+2002262819+qiyziy";

    /**
     * IRS 申请组件生成的AK
     */
    String IRS_AK = "BCDSGA_117d3967fa52d9d62a54f03b2e3bdf8e";
    /**
     * IRS 申请组件生成的SK
     */
    String IRS_SK = "BCDSGS_a11b51242885499d4245ad5cd2c3c860";


    String APP_TOKEN_SESSION_KEY = "sessionAccessToken";
    String USER_INFO_KEY = "sessionUserInfo";

}
