package com.tykj.zlbapp.config;

import com.sun.imageio.plugins.common.ImageUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import sun.font.FontDesignMetrics;

import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zsp
 * @version V1.0
 * @data 2020/6/11
 **/
@Configuration
public class WebMvcConfig {


    @Bean
    public WebMvcConfigurer corsConfigurer() {

        return new WebMvcConfigurer() {
            @Override
            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**")
                        .allowedOriginPatterns("*")
                        .allowCredentials(true)
                        .allowedMethods("GET", "POST", "DELETE", "PUT", "PATCH")
                        .maxAge(3600);
            }

            @Override
            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor(new MyInterceptor())
                        // /**代表拦截所有路径
                        .addPathPatterns("/**")
                        // 忽略的路径
                        .excludePathPatterns("/zlbAppUser/test2");
//                        .addPathPatterns("/zlbAppUser/test2");
            }
        };
    }
public static String ascii2native(String ascii){
    List<String> ascii_s = new ArrayList<String>();

    String zhengz= "\\\\u[0-9,a-f,A-F]{4}";

    Pattern p = Pattern.compile(zhengz);

    Matcher m=p.matcher(ascii);

    while (m.find()){
        ascii_s.add(m.group());
    }
    System.out.println(ascii_s);
    for (int i = 0, j = 2; i < ascii_s.size(); i++) {
        String code = ascii_s.get(i).substring(j, j + 4);
        char ch = (char) Integer.parseInt(code, 16);

        ascii = ascii.replace(ascii_s.get(i),String.valueOf(ch));
    }
    return ascii;
}





    }

}
