package com.tykj.zlbapp.subject.controller;

import com.tykj.zlbapp.subject.service.ZlbAppAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.annotation.Resource;
import java.util.Map;

/**
 * @author zsp
 * @version 1.0
 * @date 2022/8/26 10:34
 */
@RestController
@Api(tags = "浙里办人员登录模块(app)", description = "浙里办人员登录模块(app)")
@RequestMapping("/zlbAppUser")
@Slf4j
public class ZlbAppController {

    @Resource
    private ZlbAppAuthService zlbAppAuthService;

    @GetMapping("/getAppTokenByTicketId")
    @ApiOperation(value = "根据票据换取token", notes = "根据票据换取token")
    public Map<String, Object> getAppTokenByTicketId(String ticketId) {
//        HttpSession session = request.getSession();
        //1. 通过ticketId 换取 accessToken

//        //2. 保存accessToken
//        session.setAttribute(TOKEN_SESSION_KEY, tokenByTicket.g);
////        //3. 通过accessToken 获取用户信息
////        JSONObject userInfo = zlbAuthService.getUserInfoByToken(token);
////        //4. 缓存用户信息
////        session.setAttribute(USER_INFO_KEY, userInfo);
//        log.info("session:{}",session);
        return zlbAppAuthService.getTokenByTicket(ticketId);
    }

    @GetMapping("/getAppUserInfoByToken")
    @ApiOperation(value = "根据token获取当前登录的用户信息", notes = "根据token获取当前登录的用户信息")
    public Map<String, Object> getAppUserInfoByToken(String token) {

        return zlbAppAuthService.getUserInfoByToken(token);
    }

}
