package com.tykj.zlbapp.subject.controller;

import com.alibaba.fastjson.JSONObject;
import com.tykj.zlbapp.subject.service.ZlbWeChatAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import static com.tykj.zlbapp.contants.WeChatConstants.WECHAT_TOKEN_SESSION_KEY;
import static com.tykj.zlbapp.contants.WeChatConstants.WECHAT_USER_INFO_KEY;

/**
 * @author zsp
 * @version 1.0
 * @date 2022/8/23 14:19
 */
@RestController
@Api(tags = "浙里办人员登录模块(wechat)", description = "浙里办人员登录模块(wechat)")
@RequestMapping("/zlbWeChatUser")
@Slf4j
public class ZlbWeChatController {

    @Resource
    private ZlbWeChatAuthService zlbWeChatAuthService;

    @GetMapping("/getWeChatTokenByTicketId")
    @ApiOperation(value = "根据票据换取token", notes = "根据票据换取token")
    public String getTokenByTicketId(String ticketId) {
//        HttpSession session = request.getSession();
//        //1. 通过ticketId 换取 accessToken
        String token = zlbWeChatAuthService.getTokenByTicketId(ticketId);
//        //2. 保存accessToken
//        session.setAttribute(WECHAT_TOKEN_SESSION_KEY, token);
//        //3. 通过accessToken 获取用户信息
//        JSONObject userInfo = zlbWeChatAuthService.getUserInfoByToken(token);
//        //4. 缓存用户信息
//        session.setAttribute(WECHAT_USER_INFO_KEY, userInfo);
//        log.info("session:{}",session);
        return token;
    }

    @GetMapping("/getWeChatCurrentUser")
    @ApiOperation(value = "获取当前登录的用户信息", notes = "获取当前登录的用户信息")
    public JSONObject getCurrentUser(String token) {
//        HttpSession session = request.getSession();
//        Object attribute = session.getAttribute(WECHAT_USER_INFO_KEY);
//        if(attribute!= null){
//            log.info("attribute:{}",attribute);
//            return (JSONObject) attribute;
//        }else{
//            throw new RuntimeException("未登录");
//        }
        JSONObject userInfoByToken = zlbWeChatAuthService.getUserInfoByToken(token);
        if (userInfoByToken != null){
            JSONObject jsonObject = new JSONObject();
            JSONObject personInfo = userInfoByToken.getJSONObject("personInfo");
            if (personInfo != null){
                String birthday = personInfo.getString("birthday");
                String userNameEnc = personInfo.getString("userNameEnc");
                String idtype = personInfo.getString("idtype");
                String gender = personInfo.getString("gender");
                String nation = personInfo.getString("nation");
                String userId = personInfo.getString("userId");
                String idNoEnc = personInfo.getString("idNoEnc");
                String email = personInfo.getString("email");
                String phoneEnc = personInfo.getString("phoneEnc");
                JSONObject attributes = personInfo.getJSONObject("attributes");
                jsonObject.put("birthday",birthday);
                jsonObject.put("userNameEnc",userNameEnc);
                jsonObject.put("idtype",idtype);
                jsonObject.put("gender",gender);
                jsonObject.put("nation",nation);
                jsonObject.put("userId",userId);
                jsonObject.put("email",email);
                jsonObject.put("phoneEnc",phoneEnc);
                jsonObject.put("idNoEnc",idNoEnc);
                jsonObject.put("attributes",attributes);
            }
            return jsonObject;
        }
        return new JSONObject();

    }



}
