package com.tykj.zlbapp.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.zlbapp.base.ResultObj;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * UnifiedReturnConfig.
 *
 * @author zsp <xhyrzldf@gmail.com>
 * @since 2020/10/9 at 3:17 下午
 */
@Configuration
@RestControllerAdvice("com.tykj.zlbapp")
public class UnifiedReturnConfig implements ResponseBodyAdvice<Object> {

    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType,
                                  Class<? extends HttpMessageConverter<?>> selectedConverterType,
                                  ServerHttpRequest request, ServerHttpResponse response) {
        // String类型不能直接包装
        if (returnType.getGenericParameterType().equals(String.class)) {
            try {
                // 将数据包装在ResultObj里后转换为json串进行返回
                return objectMapper.writeValueAsString(new ResultObj<>(body));
            } catch (JsonProcessingException e) {
                e.getMessage();
            }
        }
        // 否则直接包装成ResultVo返回
        return new ResultObj<>(body);

    }
}

