package com.tykj.zlbapp.subject.service.impl;

import com.tykj.zlbapp.contants.AppConstants;
import com.tykj.zlbapp.subject.service.ZlbAppAuthService;
import com.tykj.zlbapp.util.HeadUtil;
import com.tykj.zlbapp.util.HttpClientUtil;
import com.tykj.zlbapp.util.MD5Util;
import org.apache.coyote.Constants;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zsp
 * @version 1.0
 * @date 2022/8/26 10:12
 */
@Service
public class ZlbAppAuthServiceImpl implements ZlbAppAuthService {

    @Resource
    private RestTemplate restTemplate;

    @Override
    public String getTokenByTicket(String ticket) {
        //请求zlbApp的接口
        //进行接口请求的构造
        //1 构造header
        HttpHeaders headers = HeadUtil.getHeader();
        //请求body为x-www-form-urlencoded方式
        Map<String, Object> params=new HashMap<>();
        //servicecode 就是ak
        params.put("servicecode",AppConstants.IRS_AK);
        params.put("method","ticketValidation");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        String format = simpleDateFormat.format(new Date());
        params.put("time",format);
        params.put("sign", MD5Util.getInstance().getMD5(AppConstants.IRS_AK+AppConstants.IRS_SK+format));
        params.put("st",ticket);
        params.put("content-type","application/x-www-form-urlencoded");
        HttpEntity httpEntity=new HttpEntity<>(params,headers);
        String body = restTemplate.postForEntity(AppConstants.ACCESS_TOKEN_URL, httpEntity, String.class).getBody();
        return body;

    }
}
