package com.tykj.zlbapp.util;

import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;

/**
 * @author LJJ
 * on 18-12-27
 */
public class SslSelfSigned {

    public static final SSLConnectionSocketFactory SSL_CONNECTION_SOCKET_FACTORY;
    protected static final Logger logger = LoggerFactory.getLogger(SslSelfSigned.class);

    static {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(TrustSelfSignedStrategy.INSTANCE).build();
        } catch (KeyManagementException | NoSuchAlgorithmException | KeyStoreException e) {
            logger.error("{}", e);
        }
        SSL_CONNECTION_SOCKET_FACTORY = new SSLConnectionSocketFactory(sslContext,
                NoopHostnameVerifier.INSTANCE);
    }

    private SslSelfSigned() {
    }
}
