package com.tykj.zlbapp.subject.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tykj.zlbapp.contants.WeChatConstants;
import com.tykj.zlbapp.subject.service.ZlbWeChatAuthService;
import com.tykj.zlbapp.util.IrsSignRes;
import com.tykj.zlbapp.util.IrsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import javax.annotation.Resource;
import java.util.Map;

/**
 * @author zsp
 * @version 1.0
 * @date 2022/8/23 13:56
 */
@Service
@Slf4j
public class ZlbWeChatAuthServiceImpl implements ZlbWeChatAuthService {

    @Resource
    private RestTemplate restTemplate;

    @Override
    public JSONObject getUserInfoByToken(String accessToken) {
        HttpHeaders headers = getHttpHeaders(WeChatConstants.GET_USER_INFO_URL);
        JSONObject body = new JSONObject();
        body.put("token", accessToken);
        HttpEntity<Map<String, Object>> request = new HttpEntity<>(body, headers);
        ResponseEntity<String> stringResponseEntity = restTemplate.postForEntity(WeChatConstants.GET_USER_INFO_URL, request, String.class);
        return checkResponse(stringResponseEntity).getJSONObject("data");
    }

    @Override
    public String getTokenByTicketId(String ticketId) {
        HttpHeaders headers = getHttpHeaders(WeChatConstants.ACCESS_TOKEN_URL);
        JSONObject body = new JSONObject();
        body.put("appId", WeChatConstants.APP_ID);
        body.put("ticketId", ticketId);
        HttpEntity<Map<String, Object>> request = new HttpEntity<>(body, headers);
        ResponseEntity<String> stringResponseEntity = restTemplate.postForEntity(WeChatConstants.ACCESS_TOKEN_URL, request, String.class);
        return checkResponse(stringResponseEntity).getJSONObject("data").getString("accessToken");
    }

    private JSONObject checkResponse(ResponseEntity<String> stringResponseEntity) {
        if (!stringResponseEntity.getStatusCode().is2xxSuccessful()) {
            //请求失败
            throw new RuntimeException("status:" + stringResponseEntity.getStatusCodeValue() + " " + stringResponseEntity.getBody());
        }
        JSONObject result = JSON.parseObject(stringResponseEntity.getBody());
        if (result.containsKey("errorCode") && result.getString("errorCode") != null && !result.getBooleanValue("success")) {
            //业务错误
            throw new RuntimeException(result.toString());
        }
        return result;
    }

    private HttpHeaders getHttpHeaders(String url) {
        IrsSignRes res = IrsUtils.sign(url, "POST");
        HttpHeaders headers = new HttpHeaders();
        headers.add(WeChatConstants.X_BG_HMAC_ACCESS_KEY, res.getAccessKey());
        headers.add(WeChatConstants.X_BG_HMAC_ALGORITHM, res.getAlgorithm());
        headers.add(WeChatConstants.X_BG_HMAC_SIGNATURE, res.getSignature());
        headers.add(WeChatConstants.X_BG_DATE_TIME, res.getDateTime());
        return headers;
    }
}
