package com.tykj.zlb.subject.controller;

import com.alibaba.fastjson.JSONObject;
import com.tykj.zlb.subject.service.ZlbAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import static com.tykj.zlb.contants.Constants.TOKEN_SESSION_KEY;
import static com.tykj.zlb.contants.Constants.USER_INFO_KEY;

/**
 * @author zsp
 * @version 1.0
 * @date 2022/8/23 14:19
 */
@RestController
@Api(tags = "浙里办人员登录模块", description = "浙里办人员登录模块")
@RequestMapping("/zlbUser")
@Slf4j
public class ZlbController {

    @Resource
    private ZlbAuthService zlbAuthService;

    @GetMapping("/getTokenByTicketId")
    @ApiOperation(value = "根据票据换取token", notes = "根据票据换取token")
    public String getTokenByTicketId(String ticketId, HttpServletRequest request) {
        HttpSession session = request.getSession();
        //1. 通过ticketId 换取 accessToken
        String token = zlbAuthService.getTokenByTicketId(ticketId);
        //2. 保存accessToken
        session.setAttribute(TOKEN_SESSION_KEY, token);
        //3. 通过accessToken 获取用户信息
        JSONObject userInfo = zlbAuthService.getUserInfoByToken(token);
        //4. 缓存用户信息
        session.setAttribute(USER_INFO_KEY, userInfo);
        log.info("session:{}",session);
        return token;
    }

    @GetMapping("/getCurrentUser")
    @ApiOperation(value = "获取当前登录的用户信息", notes = "获取当前登录的用户信息")
    public JSONObject getCurrentUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object attribute = session.getAttribute(USER_INFO_KEY);
        if(attribute!= null){
            log.info("attribute:{}",attribute);
            return (JSONObject) attribute;
        }else{
            throw new RuntimeException("未登录");
        }

    }



}
