package com.zjty.efs.bus.controller;

import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@AutoDocument
@Api(tags = "通知接口")
@RestController
@RequestMapping("/notice")
public class NoticeController {
    @Autowired
    private  NoticeService noticeService;


    /**
     * 新增通知
     * @param notice
     * @return
     */
    @ApiOperation(value = "新增通知接口")
    @ApiImplicitParam(name = "notice", value = "通知实体", dataType = "Notice", paramType = "body", required = true)
    @PostMapping("/addNotice")
    public ResponseEntity addNotice(@RequestBody @Valid Notice notice){
        return ResponseEntity.ok(noticeService.addNotice(notice));
    }

    /**
     * 修改通知
     * @param notice
     * @return
     */
    @ApiOperation(value = "修改通知接口")
    @ApiImplicitParam(name = "notice", value = "通知实体", dataType = "Notice", paramType = "body", required = true)
    @PutMapping("/updateNotice")
    public ResponseEntity updateNotice(@RequestBody @Valid Notice notice){

        return ResponseEntity.ok(noticeService.updateNotice(notice));
    }

    @ApiOperation(value = "查看通知接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "通知id", paramType = "query",
                    required = true, example = "1", dataType = "int")
    })
    @GetMapping("/getNotice")
    public ResponseEntity<Notice> getNotice(@RequestParam int id){
        return ResponseEntity.ok(noticeService.getNotice(id));
    }

    @GetMapping("/getNoticeList")
    @ApiOperation(value = "获取通知列表接口", notes = "获取列表，type为通知类型，接收 0，发送 1，草稿 2")
    @ApiImplicitParams({@ApiImplicitParam(name = "user", value = "当前用户名称", paramType = "query", required = true, example = "account", dataType = "int"),
    @ApiImplicitParam(name = "type", value = "通知类型", paramType = "query", required = true, example = "0", dataType = "int"),
    @ApiImplicitParam(name = "pageNum", value = "页码", paramType = "query", required = true, dataType = "int"),
    @ApiImplicitParam(name = "pageSize", value = "条数", paramType = "query", required = true, dataType = "int")})
    public ResponseEntity<Paging<Notice>> getNoticeList(@RequestParam String user, int type, int pageNum, int pageSize){
        Paging<Notice> data = noticeService.getReceiveList(user, type, pageNum, pageSize);
        return ResponseEntity.ok(data);
    }

    @PutMapping("/updateStatus")
    @ApiOperation(value = "修改通知为已读",notes = "status 未查看 0，已查看 1")
    @ApiImplicitParams({@ApiImplicitParam(name = "notices", value = "通知列表", paramType = "body", required = true,
            allowMultiple = true, dataType = "Notice")})
    public ResponseEntity updateStatus(@RequestBody List<Notice> notices){
        return ResponseEntity.ok(noticeService.updateStatus(notices));
    }

}
