package com.zjty.efs.ftp.controller;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.entity.CheckChunkRequest;
import com.zjty.efs.ftp.entity.MergeRequest;
import com.zjty.efs.ftp.entity.UploadRequest;
import com.zjty.efs.ftp.service.FileUploadService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@AutoDocument
@RestController
@RequestMapping("/file")
@Api(tags = "文件上传", description = "文件上传")
public class FileUploadController {

    @Autowired
    private FileUploadService fileUploadService;

    /*//文件上传
    @PutMapping("/upload1")
    public ServerResponse fileUpload(HttpServletRequest httpServletRequest){
        return fileUploadService.fileUpload(httpServletRequest);
    }*/

   /* *//**
     * @author zs
     * 检查文件存在与否
     *//*
    @PostMapping("/checkFile")
    @ResponseBody
    @ApiOperation(value = "文件检查",notes = "检查文件存在与否")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "md5File",value = "md5生成的文件名称",paramType = "query",required = true)
    })
    public ServerResponse checkFile(@RequestParam(value = "md5File") String md5File) {
        return fileUploadService.checkFile(md5File);
    }*/

    /**
     * @author zs
     * 检查分片存不存在
     */
    @PostMapping("/checkChunk")
    @ApiOperation(value = "分片检查",notes = "检查分片存不存在")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "checkChunkRequests",value = "检查分片集合存不存在",dataType = "ArrayList«CheckChunkRequest»",paramType = "query",required = true)
    })
    public ServerResponse checkChunk(@RequestBody List<CheckChunkRequest> checkChunkRequests) {
        return fileUploadService.checkChunk(checkChunkRequests);
    }

    /**
     * @author zs
     * 修改上传
     */
    @PostMapping("/upload")
    @ApiOperation(value = "文件上传",notes = "上传文件，支持断点续传")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "file",value = "文件",dataType = "file",paramType = "query",required = true),
            @ApiImplicitParam(name = "md5File",value = "MD5生成的文件名",dataType = "String",paramType = "query",required = true),
            @ApiImplicitParam(name = "chunk",value = "分片",dataType = "String",paramType = "query")
    })
    @ResponseBody
    public ServerResponse upload(@RequestParam(value = "file", required = false) MultipartFile file,
                                 @RequestParam(value = "md5File",required = false) String md5File,
                                 @RequestParam(value = "chunk",required= false) Integer chunk) { //第几片，从0开始
        return fileUploadService.upload(file,md5File,chunk);
    }

    /**
     * @author zs
     * 合成分片
     */
    @PostMapping("/merge")
    @ApiOperation(value = "合成分片",notes = "合成所有分片")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "mergeRequests",value = "需要分片合成的集合",dataType = "list",paramType = "query",required = true)
    })
    public ServerResponse merge(@RequestBody List<MergeRequest> mergeRequests){
        return fileUploadService.merge(mergeRequests);
    }

    /**
     * 扫描仪
     */
    @PostMapping("/scanner")
    public ServerResponse scanner(HttpServletRequest httpServletRequest){
        return fileUploadService.scanner(httpServletRequest);
    }
}
