package com.zjty.efs.bus.service;

import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;

import java.util.List;


public interface NoticeService {
    /**
     * 新增通知
     * @param jsonObject 通知对象
     * @return
     */
    boolean addNotice(Notice jsonObject);

    /**
     * 修改通知
     * @param jsonObject 通知对象
     * @return
     */
    boolean updateNotice(Notice jsonObject);

    /**
     * 查看通知
     * @param id 通知id
     * @param userId 当前用户
     * @return
     */
    Notice getNotice(int id, String userId);

    /**
     * 获取通知列表
     * @param user 登录用户
     *
     *  type 通知类型  接受 0，发送 1，草稿 2
     *
     * @return 通知json对象
     */
    Paging<Notice> getReceiveList(String user, int type, int pageNum, int pageSize);

    /**
     * 修改通知为已读
     * @param notices 需要修改的通知实体列表
     */
    boolean updateStatus(List<Notice> notices, String userId);


    /**
     * 获取当前用户未读的接收通知
     * @param userId　当前用户
     * @param status 0 未读
     * @param type 0 接收通知
     * @return
     */
    List<Notice> findBySender(String userId, int status, int type);
    void saveNotice(Notice notice);

    /**
     * 获取已查看/未查看
     * @param user  当前用户id
     * @param status  通知状态
     * @param pageNum
     * @param pageSize
     * @return
     */
    Paging<Notice> getListByStatus(String user, int status, int pageNum, int pageSize,int type);




}
