package com.zjty.efs.ftp.controller;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.entity.DownLoadCount;
import com.zjty.efs.ftp.entity.DownLoadRequest;
import com.zjty.efs.ftp.service.DownLoadService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@AutoDocument
@RestController
@RequestMapping("/count")
@Api(tags = "文件下载次数",description = "文件下载次数")
public class DownLoadCountController {
    @Autowired
    private DownLoadService downLoadService;

    @PutMapping("/findCount")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "DownLoadRequest",value = "看下面model",paramType = "query",required = true)
    })
    public List<DownLoadCount> findCount(@RequestBody DownLoadRequest downLoadRequest){
        return downLoadService.findCount(downLoadRequest);
    }
}
