package com.zjty.efs.bus.controller;

import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@AutoDocument
@Api(tags = "通知接口")
@RestController
@RequestMapping("/notice")
public class NoticeController {
    @Autowired
    private  NoticeService noticeService;


    @ApiOperation(value = "测试接口")
    @ApiImplicitParam(name = "notice", value = "", dataType = "String", paramType = "query", required = true)
    @PostMapping("/testNotice")
    public String test(@RequestParam String notice){
        System.out.println(notice);
        return "test";
    }

    /**
     * 新增通知
     * @param notice
     * @return
     */
    @ApiOperation(value = "新增通知接口")
    @ApiImplicitParam(name = "notice", value = "通知实体", dataType = "Notice", paramType = "body", required = true)
    @PostMapping("/addNotice")
    public String addNotice(@RequestBody @Valid Notice notice){
        System.out.println(notice);
        return noticeService.addNotice(notice);
    }

    /**
     * 修改通知
     * @param notice
     * @return
     */
    @ApiOperation(value = "修改通知接口")
    @ApiImplicitParam(name = "notice", value = "通知实体", dataType = "Notice", paramType = "body", required = true)
    @PostMapping("/updateNotice")
    public String updateNotice(@RequestBody @Valid Notice notice){
        System.out.println(notice);
        return noticeService.updateNotice(notice);
    }

    @ApiOperation(value = "查看通知接口")
    @ApiImplicitParam(name = "id", value = "通知id", paramType = "query",
            required = true, example = "1")
    @PostMapping("/getNotice")
    public String getNotice(@RequestParam int id){
        System.out.println(id);
        return noticeService.getNotice(id);
    }

    @PostMapping("/getNoticeList")
    @ApiOperation(value = "获取通知列表接口", notes = "获取列表，type为通知类型，接收 0，发送 1，草稿 2，消息提醒　0")
    @ApiImplicitParams({@ApiImplicitParam(name = "user", value = "当前用户名称", paramType = "query", required = true, example = "username", dataType = "String"),
    @ApiImplicitParam(name = "type", value = "通知类型", paramType = "query", required = true, example = "0", dataType = "int")})
    public String getNoticeList(@RequestParam String user, int type){
        return noticeService.getReceiveList(user, type);
    }



}
