package com.zjty.efs.ftp.service.impl;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.dao.DownLoadCountDao;
import com.zjty.efs.ftp.entity.DownLoadCount;
import com.zjty.efs.ftp.entity.DownLoadRequest;
import com.zjty.efs.ftp.service.DownLoadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DownLoadServiceImpl implements DownLoadService {
    @Autowired
    private DownLoadCountDao downLoadCountDao;

    @Override
    public ServerResponse findCount(DownLoadRequest downLoadRequest) {
        List<Integer> fileIdList = downLoadRequest.getFileIds();//请求的id集合
        List<DownLoadCount> loadCounts = new ArrayList<>();
        if(fileIdList != null && fileIdList.size() != 0){
            loadCounts = downLoadCountDao.findCount(downLoadRequest.getUserId(),fileIdList);
            if(loadCounts.size() != fileIdList.size()){
                //没有文件id
                List<Integer> idList = new ArrayList<>();//数据库id集合
                for(DownLoadCount downLoadCount:loadCounts){
                    idList.add(downLoadCount.getFileId());
                }
                for(Integer i:fileIdList){
                    if(!idList.contains(i)){
                        DownLoadCount downLoadCount = new DownLoadCount();
                        downLoadCount.setUserId(downLoadRequest.getUserId());
                        downLoadCount.setFileId(i);
                        downLoadCount.setCount(0);
                        loadCounts.add(downLoadCount);
                    }
                }
            }
        }
        return ServerResponse.success(loadCounts);
    }
}
