package com.zjty.efs.user.subject.service.impl;

import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.tool.EfsLogUtil;
import com.zjty.efs.misc.util.MD5Untils;
import com.zjty.efs.user.subject.dao.UserDao;
import com.zjty.efs.user.subject.entity.NameListVo;
import com.zjty.efs.user.subject.entity.UserDo;
import com.zjty.efs.user.subject.entity.UserVo;
import com.zjty.efs.user.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-24
 */
@Service
@Slf4j
public class UserServiceImpl implements UserService {

    @Autowired
    private UserDao userDao;
    @Autowired
    private EfsLogUtil efsLogUtil;

    @Override
    public UserDo update(UserDo userDo) {
        userDao.save(userDo);
        return userDao.findById(userDo.getId()).get();
    }

    @Override
    public UserDo findById(String id) {
        return userDao.findById(id).get();
    }

    @Override
    public UserVo findAllUser(String id, Integer page, Integer size) {
        Pageable pageable = PageRequest.of(page, size, Sort.Direction.ASC, "name");
        Page<UserDo> all = userDao.findAll(pageable);

        return new UserVo((int) userDao.count(), page, size, all.getContent());
    }

    @Override
    public Boolean updateUserStatus(String id, Integer status) {

        UserDo userDo = userDao.findById(id).get();
        userDo.setStatus(status);
        userDao.save(userDo);

        //添加日志
        String action = "冻结";
        if (status == 1) {
            action = "解锁";
        }
        String msg = "[管理员]" + action +
                "了[" + userDo.getUnit() +
                "][" + userDo.getDepartment() +
                "][" + userDo.getName() +
                "]的账号";
        efsLogUtil.addLog(new EfsLog(null, "admin", msg, new Date()));
        return true;
    }

    @Override
    public List<NameListVo> getAllowAckUser(String id) {
        List<NameListVo> rs = new ArrayList<>();
        userDao.findAll().forEach(
                o -> {
                    if (!o.getId().equals(id) && !"admin".equals(o.getAccount())) {
                        NameListVo nameListVo = new NameListVo(o.getId(), o.getName(), o.getDepartment());
                        rs.add(nameListVo);
                    }
                }
        );
        return rs;
    }

    @Override
    public UserDo resetPassword(String id, String pwd) {
        UserDo userDo = userDao.findById(id).get();
        userDo.setPassword(MD5Untils.getMD5Str(pwd));
        userDao.save(userDo);

        String msg = "[管理员]重置了" + "["+
                userDo.getUnit() + "][" + userDo.getDepartment()
                + "][" + userDo.getName() + "]的密码";

        efsLogUtil.addLog(new EfsLog(null,"admin",
                msg,
                new Date()));

        return userDo;
    }

    @Override
    public UserDo addUser(UserDo userDo) {
        if (userDao.findByAccount(userDo.getAccount()).size() < 1) {
            userDo.setPassword(MD5Untils.getMD5Str(userDo.getPassword()));
            userDo.setUpdateTime(new Date());
            userDao.save(userDo);

            //创建日志
            String msg = "[管理员]用户了[" + userDo.getUnit() +
                    "][" + userDo.getDepartment() +
                    "][" + userDo.getName() +
                    "]";
            efsLogUtil.addLog(new EfsLog(null,"admin",msg, new Date()));

            return userDo;
        }else {
            log.warn("新增出错；已存在该用户");
            return new UserDo();
        }
    }

    @Override
    public UserDo login(String username, String password) {
        log.info("用户登陆：{}", username);
        List<UserDo> byUsername = userDao.findByAccount(username);
        log.info("{}", byUsername);
        if (byUsername.size() == 1) {

            if (byUsername.get(0).getStatus() == 0) {
                log.warn("登陆用户被冻结:{}", byUsername.get(0).getAccount());
                return new UserDo();
            }

            log.info("用户存在");
            if (byUsername.get(0).getPassword().equals(MD5Untils.getMD5Str(password))) {
                return byUsername.get(0);
            } else {
                log.warn("用户登陆密码错误,错误账号:{}，姓名:{}", byUsername.get(0).getAccount(), byUsername.get(0).getName());
                return new UserDo();
            }
        } else {
            log.error("用户登陆出错,错误对象：{}",byUsername);
            return new UserDo();
        }
    }

    @Override
    public UserDo updatePwd(String id, String oPwd, String nPwd) {
        Optional<UserDo> user2 = userDao.findById(id);

        UserDo user = user2.get();

        if (!user.getPassword().equals(MD5Untils.getMD5Str(oPwd))) {
            log.warn("密码不对");
            return new UserDo();
        }

        user.setPassword(MD5Untils.getMD5Str(nPwd));
        userDao.save(user);

        //修改记录日志
        String msg = "[" + user.getUnit() +
                "][" + user.getDepartment() +
                "][" + user.getName() +
                "]修改了密码";
        efsLogUtil.addLog(new EfsLog(null, id, msg, new Date()));
    return user;
    }
}
