package com.zjty.efs.ftp.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@AutoDocument
@AllArgsConstructor@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "DownLoadCount",description = "文件下载次数")
public class DownLoadCount {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(name = "id",value = "文件下载次数id",notes = "文件下载次数id",example = "1")
    private Integer id;
    @ApiModelProperty(name = "fileId",value = "文件id",notes = "文件id",example = "1")
    private Integer fileId;//文件id
    @ApiModelProperty(name = "userId",value = "用户id",notes = "用户id",example = "0f46770d-b602-4a80-bdec-a12978022625")
    private String userId;//用户id
    @ApiModelProperty(name = "count",value = "下载次数id",notes = "下载次数id",example = "1")
    private Integer count;//下载次数
}
