package com.zjty.efs.log.subject.controller;

import com.zjty.efs.log.subject.entity.EfsLogVo;
import com.zjty.efs.log.subject.service.EfsLogService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-26
 */
@RestController
@RequestMapping("/api")
@AutoDocument
@Api(tags = "日志模块")
public class EfsController {

    @Autowired
    private EfsLogService efsLogService;

    @GetMapping("/log")
    @ApiOperation(value = "查询日志的接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="page",value="页数，1开始",dataType="integer", paramType = "query"),
            @ApiImplicitParam(name="size",value="每页大小",dataType="integer", paramType = "query")
    })
    public ResponseEntity<EfsLogVo> getAll(@RequestParam(value = "page") Integer page,
                                           @RequestParam(value = "size") Integer size) {
        page = page -1;
        EfsLogVo rs = efsLogService.findAllLog(page, size);
        return ResponseEntity.ok(rs);
    }

}
