package com.zjty.efs.ftp.controller;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.service.FileUploadService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

@AutoDocument
@RestController
@RequestMapping("/file")
@Api(tags = "文件上传", description = "文件上传")
public class FileUploadController {

    @Autowired
    private FileUploadService fileUploadService;

    //文件上传
    @PutMapping("/upload")
    public ServerResponse fileUpload(HttpServletRequest httpServletRequest){
        return fileUploadService.fileUpload(httpServletRequest);
    }

    /**
     * @author zs
     * 检查文件存在与否
     */
    @PostMapping("/checkFile")
    @ResponseBody
    @ApiOperation(value = "文件检查",notes = "检查文件存在与否")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "md5File",value = "md5生成的文件名称",paramType = "String",required = true)
    })
    public ServerResponse checkFile(@RequestParam(value = "md5File") String md5File) {
        return fileUploadService.checkFile(md5File);
    }

    /**
     * @author zs
     * 检查分片存不存在
     */
    @PostMapping("/checkChunk")
    @ResponseBody
    @ApiOperation(value = "分片检查",notes = "检查分片存不存在")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "md5File",value = "md5生成的文件名称",paramType = "String",required = true),
            @ApiImplicitParam(name = "chunk",value = "分片名称",paramType = "Integer",required = true)
    })
    public ServerResponse checkChunk(@RequestParam(value = "md5File") String md5File,
                              @RequestParam(value = "chunk") Integer chunk) {
        return fileUploadService.checkChunk(md5File,chunk);
    }

    /**
     * @author zs
     * 修改上传
     */
    @PostMapping("/upload")
    @ResponseBody
    @ApiOperation(value = "文件上传",notes = "上传文件，支持断点续传")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "md5File",value = "md5生成的文件名称",paramType = "String",required = true),
            @ApiImplicitParam(name = "chunk",value = "分片名称",paramType = "Integer",required = true),
            @ApiImplicitParam(name = "file",value = "文件",paramType = "MultipartFile",required = true)
    })
    public ServerResponse upload(@RequestParam(value = "file") MultipartFile file,
                          @RequestParam(value = "md5File") String md5File,
                          @RequestParam(value = "chunk",required= false) Integer chunk) { //第几片，从0开始
        return fileUploadService.upload(file,md5File,chunk);
    }

    /**
     * @author zs
     * 合成分片
     */
    @PostMapping("/merge")
    @ResponseBody
    @ApiOperation(value = "合成分片",notes = "合成所有分片")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "md5File",value = "md5生成的文件名称",paramType = "String",required = true),
            @ApiImplicitParam(name = "chunk",value = "最后的分片名称",paramType = "Integer",required = true),
            @ApiImplicitParam(name = "file",value = "文件",paramType = "MultipartFile",required = true)
    })
    public ServerResponse  merge(@RequestParam(value = "chunks",required =false) Integer chunks,
                          @RequestParam(value = "md5File") String md5File,
                          @RequestParam(value = "name") String name){
        return fileUploadService.merge(chunks,md5File,name);
    }

}
