package com.zjty.efs.ftp.service;


import com.zjty.efs.ftp.base.response.ServerResponse;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

public interface FileUploadService {

    /**
     * 文件上传
     * @param request
     * @return
     */
    ServerResponse fileUpload(HttpServletRequest request);

    /**
     * @author zs
     * 检查文件存在与否
     */
    ServerResponse checkFile(String md5File);

    /**
     * @author zs
     * 检查分片存不存在
     */
    ServerResponse checkChunk(String md5File, Integer chunk);

    /**
     * @author zs
     * 修改上传
     */
    ServerResponse upload(MultipartFile file, String md5File, Integer chunk);

    /**
     * @author zs
     * 合成分片
     */
    ServerResponse  merge(Integer chunks, String md5File, String name);

}
