package com.zjty.efs.user.subject.controller;

import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.tool.EfsLogUtil;
import com.zjty.efs.misc.config.AutoDocument;
import com.zjty.efs.user.subject.dao.UserDao;
import com.zjty.efs.user.subject.entity.*;
import com.zjty.efs.user.subject.service.UserService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

import static org.springframework.web.bind.annotation.RequestMethod.*;
import static org.springframework.web.bind.annotation.RequestMethod.OPTIONS;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-24
 */
@RestController
@RequestMapping("/api")
@AutoDocument
@Api(tags = "用户模块接口")
@Slf4j
//@CrossOrigin(origins = "*", allowCredentials = "true", methods = {GET, POST, PUT, DELETE, PATCH, OPTIONS})
public class UserController {

    @Autowired
    private UserService userService;
    @Autowired
    private EfsLogUtil efsLogUtil;

    @GetMapping("/user")
    @ApiOperation(value = "根据id查询用户的接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="id",dataType="string", paramType = "query")
    })
    public ResponseEntity<UserDo> getUserById(@RequestParam(value = "id") String id) {
        log.info("查询id:{}", id);
        UserDo user = userService.findById(id);
        return ResponseEntity.ok(user);
    }

    @GetMapping("/otherUser")
    @ApiOperation(value = "根据id获取相关人员信息接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query"),
            @ApiImplicitParam(name="page",value="当前页，1开始",dataType="integer", paramType = "query"),
            @ApiImplicitParam(name="size",value="每页大小",dataType="integer", paramType = "query")

    })
    public ResponseEntity<UserVo> getAllUser(@RequestParam(value = "id") String id,
                                             @RequestParam(value = "page") Integer page,
                                             @RequestParam(value = "size") Integer size) {
        UserVo allUser = userService.findAllUser(id, page - 1, size);
        return ResponseEntity.ok(allUser);
    }


    @PutMapping("/reset")
    @ApiOperation(value = "重置用户密码")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query")
    })
    public ResponseEntity<UserPwdVo> resetStatus(@RequestParam(value = "id") String id) {

        String pwd = "qwer1234";
        UserDo userDo = userService.resetPassword(id, pwd);

        return ResponseEntity.ok(new UserPwdVo(id, pwd, userDo.getAccount()));
    }

    @PutMapping("/pwd")
    @ApiOperation(value = "用户修改密码")
    @ApiImplicitParams({

    })
    public ResponseEntity<UserPwdVo> updatePwd(
                                    @RequestBody AccVo accVo
                                   ) {

        String oPwd = accVo.getOPwd();
        String nPwd = accVo.getNPwd();
        String id = accVo.getId();
        UserDo user = userService.updatePwd(id, oPwd, nPwd);
        if (user.getAccount() == null) {
            return ResponseEntity.status(403).body(new UserPwdVo("","",""));
        }
        return ResponseEntity.ok(new UserPwdVo(id, nPwd, user.getAccount()));
    }

    @PutMapping("/login")
    @ApiOperation(value = "登陆接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="account",value="用户名",dataType="string", paramType = "query",example = "mcj"),
            @ApiImplicitParam(name="password",value="密码",dataType="string", paramType = "query")
    })
    public ResponseEntity<UserDo> login(@RequestParam(value = "account") String username,
                                         @RequestParam(value = "password") String password) {
        log.info("account:{} 登陆", username);

        UserDo user = userService.login(username, password);


        if (user.getName() != null) {
            return ResponseEntity.ok(user);
        } else {
            return ResponseEntity.status(403).body(new UserDo());
        }
    }

//    public ResponseEntity logout()


    @PutMapping("/status")
    @ApiOperation(value = "修改人员状态接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员主键id",dataType="string", paramType = "query"),
            @ApiImplicitParam(name="status",value="修改的状态 1正常 2冻结",dataType="integer", paramType = "query")
    })
    public ResponseEntity<UserStatusVo> alertStatus(@RequestParam(value = "id") String id,
                                      @RequestParam(value = "status") Integer status) {

        userService.updateUserStatus(id, status);
        return ResponseEntity.ok(new UserStatusVo(id,"修改成功", status));
    }

    @PostMapping("/user")
//    @ApiOperation(value = "新增人员信息的接口")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name="userDo",value="人员信息",dataType="object", paramType = "body")
//    })
    public ResponseEntity<UserDo> addUser(@RequestBody UserDo userDo) {

        UserDo user = userService.addUser(userDo);
        if (user.getAccount() == null) {
            return ResponseEntity.status(403).body(user);
        } else {
            return ResponseEntity.ok(user);
        }
    }

    @Autowired
    private UserDao userDao;

    @PutMapping("/user")
    @ApiOperation(value = "更新人员信息的接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="type",value="1_管理员的操作，2_用户的操作",dataType="int", paramType = "query"),
            @ApiImplicitParam(name="userDo",value="人员信息",dataType="object", paramType = "body")
    })
    public ResponseEntity<UserDo> updateUser(@RequestParam(value = "type" )Integer type,
                                             @RequestBody UserDo userDo) {
        if (userDo.getId() == null) {
            return ResponseEntity.status(403).body(new UserDo());
        }

        UserDo old = userDao.findById(userDo.getId()).get();

        UserDo rs = userService.update(userDo);

        //添加日志
        String id = userDo.getId();
        String msg = "";
        if (type == 1 ) {
            id = "admin";
            msg = "[管理员]修改了[" + old.getUnit() +
                    "_" + old.getName() +
                    "]的信息";
            efsLogUtil.addLog(new EfsLog(null,id,msg,new Date()));
        } else {
            if (type == 2) {
                msg = userDo.getName() + "修改了账户信息";
                efsLogUtil.addLog(new EfsLog(null, id, msg, new Date()));
            }
        }
        return ResponseEntity.ok(rs);
    }

    @GetMapping("userList")
    @ApiOperation(value = "发布任务时查询人员的接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query")
    })
    public ResponseEntity<List<NameListVo>> getNameList(@RequestParam (value = "id") String id) {
        List<NameListVo> rs = userService.getAllowAckUser(id);
        return ResponseEntity.ok(rs);
    }

    @ApiOperation(value = "查询单位接口")
    @GetMapping("/unit")
    public ResponseEntity<List<Unit>> getUnit() {
        return ResponseEntity.ok(userService.findUnit());
    }

    @GetMapping("/unit/meb")
    @ApiOperation(value = "根据单位查询人员")
    public ResponseEntity getUnitMeb(@RequestParam(value = "unit") String unit) {
        return ResponseEntity.ok(userService.findByUnit(unit));
    }

    @GetMapping("/unit/allUU")
    @ApiOperation(value = "查询所有单位和人员")
    public ResponseEntity getUnitMeb2(@RequestParam(value = "id") String id) {
        return ResponseEntity.ok(userService.findDepUserI(id));
    }

}
