package com.zjty.efs.user.subject.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-23
 */
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@AutoDocument
@ApiModel(value = "用户", description = "用户实体类")
@Table(name = "user")
public class User {

    @ApiModelProperty(value = "id",example = "jksdhfjks5")
    @Id
    private String id;

    @NotEmpty(message = "用户姓名不可为空")
    @ApiModelProperty(value = "用户姓名",example = "mcj")
    private String name;

    @NotNull(message = "岗位不可为空")
    @ApiModelProperty(value = "岗位",example = "1")
    private String job;

    @NotEmpty(message = "身份证号码不可为空")
    @ApiModelProperty(value = "身份证",example = "48489498131566546")
    private String idCard;

    @NotEmpty(message = "联系方式不可为空")
    @ApiModelProperty(value = "联系方式",example = "113665465465")
    private String tel;

    @NotEmpty(message = "地址不可为空")
    @ApiModelProperty(value = "地址",example = "xx路xx楼xx号")
    private String address;

    @NotNull(message = "到岗时间不可为空")
    @ApiModelProperty(value = "到岗时间",example = "2019-01-45 12:12:12")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date insertTime;

    @NotNull(message = "部门不可为空")
    @ApiModelProperty(value = "部门id",example = "1")
    private String departId;

    @NotNull(message = "性别不可为空")
    @ApiModelProperty(value = "性别,0_男,1_女",example = "1")
    private Integer sex;

    @ApiModelProperty(value = "备注",example = "dadsd")
    private String remark;

    @NotEmpty(message = "用户名不可为空")
    @ApiModelProperty(value = "用户名",example = "username")
    private String username;

    @NotEmpty(message = "密码不可为空")
    @ApiModelProperty(value = "密码",example = "password")
    private String password;

    @NotNull(message = "用户锁定状态不可为空")
    @ApiModelProperty(value = "用户锁定状态,0_未锁定,1_已锁定",example = "1")
    private Integer status;

}
