package com.zjty.efs.bus.util;

import com.alibaba.fastjson.JSONArray;
import com.zjty.efs.bus.entity.Addressee;
import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.service.AttentionService;
import com.zjty.efs.bus.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Component
public class Job {
    @Autowired
    NoticeService noticeService;
    @Autowired
    AttentionService attentionService;
    @Scheduled(cron = "0 */1 * * * ?")
    public void cronJob() {

        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, 7);
        Date time = calendar.getTime();
        List<Notice> noticeList = noticeService.findBySender("",0,0);

        String data = "";
        for(Notice notice:noticeList){
            Attention attention = new Attention();
            Date endTime = notice.getDeadline();

            long days = (endTime.getTime()-now.getTime())/(1000*3600*24);
            System.out.println(days);
            if (days == 3 || days == 1){
                data = "您收到来自[" + notice.getName() +"]的[" + notice.getTitle() + "],还有" + days +"天失效。";
                attention.setData(data);
                attention.setNoticeId(notice.getId());

                String str = notice.getAddressee();
                List<Addressee> addresseeList = JSONArray.parseArray(str,Addressee.class);
                String userId = addresseeList.get(0).getId();
                attention.setUserId(userId);
                attention.setStatus(0);
                attention.setUpdateTime(new Date());
                attentionService.addAttention(attention);
            }

        }
    }

}
