package com.zjty.efs.user.subject.controller;

import com.zjty.efs.user.subject.entity.User;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-24
 */
@RestController
@RequestMapping("/api")
public class UserController {

    @GetMapping
    @ApiOperation(value = "查询用户的接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="Integer", paramType = "int",required = true)
    })
    public ResponseEntity<User> getUserById(@RequestParam Integer id) {

        return ResponseEntity.ok(new User());
    }
}
