package com.zjty.efs.user.subject.service;

import com.sun.tools.corba.se.idl.InterfaceGen;
import com.zjty.efs.user.subject.entity.User;

import java.util.List;

/**
 * 提供给前端的方法
 *
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-24
 */
public interface UserService {

    /**
     * 根据id查找
     * @param id user id
     * @return user obj
     */
    User findById(Integer id);

    /**
     * 查找所用用户，除了管理员
     * @return users obj
     */
    List<User> findAllUser();

    /**
     * 更新人员状态
     * 1，正常 2，冻结
     * @return true 成功 false 失败
     */
    Boolean updateUserStatus();

    /**
     * 查询可以发布消息的人员
     * 需除去admin及自己
     * @param id 人员id
     * @return users obj
     */
    List<User> getAllowAckUser(Integer id);

    /**
     * 重置密码
     * @param id 人员id
     * @param pwd 重置的密码
     * @return true 成功 false 失败
     */
    Boolean resetPassword(Integer id, String pwd);

    /**
     * 创建用户
     * @param user 用户对象
     * @return true or false
     */
    Boolean  addUser(User user);




}
