package com.zjty.efs.ftp.service.impl;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.entity.*;
import com.zjty.efs.ftp.service.FileUploadService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
@Slf4j
public class FileUploadServiceImpl implements FileUploadService {

    @Value("${file.address}")
    private String fileAddress;

    /**
     * 前台文件上传
     * @param request
     * @return
     */
    @Override
    public ServerResponse fileUpload(HttpServletRequest request) {
        List<MultipartFile> multipartFiles = ((MultipartHttpServletRequest)request).getFiles("file");
        List<MergeResponse> fileReturns = new ArrayList<>();
        if(multipartFiles != null && multipartFiles.size() != 0){
            for(MultipartFile multipartFile:multipartFiles){
                InputStream is = null;
                BufferedInputStream bis = null;
                FileOutputStream fos = null;
                BufferedOutputStream bos = null;
                MergeResponse fileReturn = new MergeResponse();
                String sourceName = multipartFile.getOriginalFilename();
                String suffix = sourceName.substring(sourceName.lastIndexOf("."));
                String fileName = UUID.randomUUID().toString() + suffix;
                //不存在该目录，创建目录
                File file = new File(fileAddress);
                if(!file.exists()){
                    file.mkdirs();
                }
                String savePath = file.getAbsolutePath() + "/" + fileName;
                File createFile = new File(savePath);
                try {
                    is = multipartFile.getInputStream();
                    bis = new BufferedInputStream(is);
                    fos = new FileOutputStream(createFile);
                    bos = new BufferedOutputStream(fos);
                    int len = -1;
                    byte[] b = new byte[1024];
                    while ((len = bis.read(b)) != -1){
                        bos.write(b,0,len);
                    }
                    fileReturn.setName(sourceName);
                    fileReturn.setPath(savePath);
                    fileReturns.add(fileReturn);
                } catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }finally {
                    try {
                        bis.close();
                        is.close();
                        bos.close();
                        fos.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }else {
            log.error("上传失败，请重新确定key值，重新上传");
            return ServerResponse.error("上传失败，请重新确定key值，重新上传");
        }
        return ServerResponse.success(fileReturns);
    }

    @Override
    public ServerResponse checkFile(String md5File) {
        Boolean exist = false;

        //实际项目中，这个md5File唯一值，应该保存到数据库或者缓存中，通过判断唯一值存不存在，来判断文件存不存在，这里我就不演示了
		/*if(true) {
			exist = true;
		}*/
        return ServerResponse.success(exist);
    }

    @Override
    public ServerResponse checkChunk(List<CheckChunkRequest> checkChunkRequests) {
        List<CheckChunkResponse> chunkResponses = new ArrayList<>();
        if(checkChunkRequests != null && checkChunkRequests.size() != 0){
            for(CheckChunkRequest chunkRequest:checkChunkRequests){
                String md5File = chunkRequest.getMd5File();
                Integer chunk = chunkRequest.getChunk();
                CheckChunkResponse chunkResponse = new CheckChunkResponse();
                chunkResponse.setChunk(chunk);
                chunkResponse.setMd5File(md5File);
                Integer exist = 0;
                String chunkPath = fileAddress + "/" + md5File + "/";//分片存放目录
                String chunkName = chunk+ ".tmp";//分片名
                File file = new File(chunkPath + chunkName);
                if (file.exists()) {
                    exist = 1;
                }
                chunkResponse.setExist(exist);
            }
        }
        return ServerResponse.success(chunkResponses);
    }

    @Override
    public ServerResponse upload(List<UploadRequest> uploadRequests) {
        if(uploadRequests != null && uploadRequests.size() != 0){
            for(UploadRequest uploadRequest:uploadRequests){
                String md5File = uploadRequest.getMd5File();
                Integer chunk = uploadRequest.getChuck();
                MultipartFile file = uploadRequest.getMultipartFile();
                String chunkPath = fileAddress + "/" + md5File + "/";//分片存放目录
                File dirFile = new File(chunkPath);
                if (!dirFile.exists()) {//目录不存在，创建目录
                    dirFile.mkdirs();
                }
                String chunkName;
                if(chunk == null) {//表示是小文件，还没有一片
                    chunkName = "0.tmp";
                }else {
                    chunkName = chunk + ".tmp";
                }
                String filePath = chunkPath + chunkName;
                File saveFile = new File(filePath);
                try {
                    if (!saveFile.exists()) {
                        saveFile.createNewFile();//文件不存在，则创建
                    }
                    file.transferTo(saveFile);//将文件保存
                } catch (IOException e) {
                    log.error(filePath + "文件没有保存");
                }
            }
        }
        return ServerResponse.success("true");
    }

    @Override
    public ServerResponse merge(List<MergeRequest> uploadRequests) {
        List<MergeResponse> fileReturns = new ArrayList<>();
        if(uploadRequests != null && uploadRequests.size() != 0){
            for(MergeRequest mergeRequest: uploadRequests){
                MergeResponse fileReturn = new MergeResponse();
                String md5File = mergeRequest.getMd5File();
                Integer chunks = mergeRequest.getChuck();
                String name = mergeRequest.getName();
                fileReturn.setName(name);//放入文件名称
                fileReturn.setPath(fileAddress + "/" + name);//文件存储地址
                fileReturn.setSaveSuccess(1);//默认保存成功，如果失败，重新set为0
                FileOutputStream fileOutputStream = null;  //合成后的文件
                try {
                    fileOutputStream = new FileOutputStream(fileAddress + "/" + name);
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                try {
                    byte[] buf = new byte[1024];
                    for(long i = 0;i < chunks;i++) {
                        String chunkFile = i + ".tmp";
                        File file = new File(fileAddress + "/" + md5File+"/" + chunkFile);
                        InputStream inputStream = new FileInputStream(file);
                        int len = 0;
                        while((len = inputStream.read(buf)) != -1){
                            fileOutputStream.write(buf,0,len);
                        }
                        inputStream.close();
                    }
                    //删除md5目录，及临时文件
                    deleteFile(new File(fileAddress + "/" + md5File));
                } catch (Exception e) {
                    fileReturn.setSaveSuccess(0);//保存失败
                    log.error(fileReturn.getPath() + "文件保存失败");
                }finally {
                    try {
                        fileReturns.add(fileReturn);
                        fileOutputStream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ServerResponse.success(fileReturns);
    }

    /**
     * 删除文件夹下所有文件以及文件夹
     * @param file
     */
    public static void deleteFile(File file){
        //判断文件不为null或文件目录存在
        if (file == null || !file.exists()){
            System.out.println("文件删除失败,请检查文件路径是否正确");
            return;
        }
        //取得这个目录下的所有子文件对象
        File[] files = file.listFiles();
        //遍历该目录下的文件对象
        for (File f: files){
            //打印文件名
            //判断子目录是否存在子目录,如果是文件则删除
            if (f.isDirectory()){
                deleteFile(f);
            }else {
                f.delete();
            }
        }
        //删除空文件夹  for循环已经把上一层节点的目录清空。
        file.delete();
    }
}
