package com.zjty.efs.ftp.service.impl;

import com.zjty.efs.ftp.service.FileDownLoadService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;

@Service
@Slf4j
public class FileDownLoadServiceImpl implements FileDownLoadService {

    @Value("${file.address}")
    private String fileAddress;

    @Override
    public void fileDownLoad(String fileName, HttpServletResponse response, HttpServletRequest httpServletRequest) {
        if(fileName != null){
            response.setHeader("content-type", "application/octet-stream");
            response.setContentType("application/octet-stream");
            try {
                response.setHeader("Content-Disposition", "attachment;filename="+new String(fileName.getBytes("utf-8"),"utf-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            File file = new File(fileAddress + "/" + fileName);
            //如果文件存在，返回文件，文件不存在，返回文件不存在提示
            boolean fileExist = false;
            if(file.length() != 0){
                fileExist = true;
            }
            if(fileExist){
                setFileDownloadHeader(httpServletRequest,response,fileName);
                OutputStream os = null;
                InputStream is = null;
                BufferedInputStream bs = null;
                byte[] buffer = new byte[1024];
                try {
                    is = new FileInputStream(file);
                    bs = new BufferedInputStream(is);
                    os = response.getOutputStream();
                    int i = bs.read(buffer);
                    while (i != -1) {
                        os.write(buffer, 0, i);
                        i = bs.read(buffer);
                    }
                    os.flush();
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    try {
                        bs.close();
                        is.close();
                        os.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }else {
                log.info("该文件不存在");
            }
        }
    }

    /**
     * 解决中文名称
     * @param request
     * @param response
     * @param fileName
     */
    public void setFileDownloadHeader(HttpServletRequest request, HttpServletResponse response, String fileName) {
        try {
            //中文文件名支持
            String encodedfileName;
            String agent = request.getHeader("USER-AGENT");
            if (null != agent && agent.contains("MSIE")) {//IE
                encodedfileName = java.net.URLEncoder.encode(fileName, "UTF-8");
            } else if (null != agent && agent.contains("Mozilla")) {
                encodedfileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
            } else {
                encodedfileName = java.net.URLEncoder.encode(fileName, "UTF-8");
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedfileName + "\"");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

}
