package com.zjty.efs.bus.service.impl;

import com.zjty.efs.bus.Dao.AttentionDao;
import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.AttentionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class AttentionServiceImpl implements AttentionService {
    @Autowired
    AttentionDao attentionDao;
    @Override
    public Paging<Attention> getAttentionList(String userId, int pageNum, int pageSize) {
        try {
            Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
            Page<Attention> p = attentionDao.findOutByUserId(userId, pageable);

            Paging<Attention> paging= new Paging<>();
            paging.setTotal((int)p.getTotalElements());
            paging.setPageNum(pageNum);
            paging.setPageSize(pageSize);
            paging.setData(p.getContent());
            return paging;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    @Transactional
    public boolean addAttention(Attention attention) {
        try{
            attentionDao.save(attention);
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Transactional
    public boolean updateStatus(List<Attention> attentions) {
        try{
            for(Attention attention:attentions){
                attention.setStatus(1);
                attentionDao.save(attention);
            }
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public boolean getRedDot(String userId) {
        List<Attention> attentions = attentionDao.findOutByUserIdAndStatus(userId, 0);
        if(attentions.size() > 0){
            return true;
        }else {
            return false;
        }
    }

}
