package com.zjty.efs.bus.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.Dao.NoticeDao;
import com.zjty.efs.bus.entity.Addressee;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.tool.EfsLogUtil;
import com.zjty.efs.user.subject.entity.UserDo;
import com.zjty.efs.user.subject.service.UserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.*;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.lang.reflect.Array;
import java.util.*;

@Service
public class NoticeServiceImpl implements NoticeService {
    @Autowired
    NoticeDao noticeDao;
    @Autowired
    EfsLogUtil efsLogUtil;
    @Autowired
    UserService userService;

    @Override
    @Transactional
    public boolean addNotice(Notice notice){
        try{
            UserDo userDo = userService.findById(notice.getSender()); // 发送人
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, 7);
            String[] strings = notice.getAddressee().split(",");
            notice.setUpdateTime(new Date());
            notice.setDeadline(calendar.getTime());
            notice.setUnit(userDo.getUnit());
            notice.setStatus(0);

            if (notice.getType() == 2){
                //保存为草稿
                List<Addressee> addresseeList = new ArrayList<>();
                for(String addressee:strings){
                    UserDo userDo1 = userService.findById(addressee);
                    Addressee addressee1 = new Addressee();
                    addressee1.setId(userDo1.getId());
                    addressee1.setName(userDo1.getName());
                    addresseeList.add(addressee1);
                }
                notice.setAddressee(JSONObject.toJSONString(addresseeList));
                noticeDao.save(notice);

            }else {
                for(String addressee:strings){
                    List<Addressee> addresseeList = new ArrayList<>();
                    UserDo userDo1 = userService.findById(addressee);
                    Addressee addressee1 = new Addressee();
                    addressee1.setId(userDo1.getId());
                    addressee1.setName(userDo1.getName());
                    addresseeList.add(addressee1);
                    Notice notice1 = transform(notice);  //发送通知
                    Notice notice2 = transform(notice);  // 接收通知

                    String add = JSONObject.toJSONString(addresseeList);
                    notice1.setAddressee(add);
                    notice2.setAddressee(add);
                    notice2.setUnit(userDo1.getUnit());
                    notice2.setType(0);
                    noticeDao.save(notice1);
                    noticeDao.save(notice2);


                    String data1 = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                            + "]给[" + userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "发送了关于[" + notice.getTitle() + "]的通知";

                    String data2 = "[" +userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "]收到了来自[" + userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                            + "]关于[" + notice.getTitle() + "的通知";

                    efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data1, new Date()));
                    efsLogUtil.addLog(new EfsLog(null, userDo1.getId(), data2, new Date()));
                }



            }
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }


//    @Override
//    @Transactional
//    public boolean addNotice(Notice notice) {
//        try{
//
//            Calendar calendar = Calendar.getInstance();
//            calendar.add(Calendar.DATE, 7);
//            UserDo userDo = userService.findById(notice.getSender()); // 发送人
//
//            notice.setUpdateTime(new Date());
//            notice.setDeadline(calendar.getTime());
//            notice.setUnit(userDo.getUnit());
//            notice.setStatus(0);
//
//
//            String data = "";
//
//            if(notice.getType() == 2){
//                //如果是草稿
//                data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
//                        + "]新增关于[" + notice.getTitle() + "草稿";
//                noticeDao.save(notice);
//            }else {
//                //如果是发送，就新增接收
//
//                String[] addressees = notice.getAddressee().split(",");
//                List<Notice> noticeList = new ArrayList<>();
//                for (String addressee:addressees){
//                    Notice notice2 = transform(notice);
//                    notice2.setAddressee(addressee);
//                    noticeList.add(notice2);  //已发送保存
//
//                    UserDo userDo1 = userService.findById(addressee); //接收人
//
//                    data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
//                            + "]给[" + userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
//                            + "发送了关于[" + notice.getTitle() + "]的通知";
////                    Notice notice1 = new Notice();
//                    Notice notice1 = transform(notice);//已接收
//                    notice1.setType(0);
//                    notice1.setTitle(notice.getTitle());
//                    notice1.setAddressee(addressee);
//                    notice1.setUnit(userDo1.getUnit());
//                    noticeDao.save(notice1);
//                    String data1 = "[" +userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
//                            + "]收到了来自[" + userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
//                            + "]关于[" + notice.getTitle() + "的通知";
//                    efsLogUtil.addLog(new EfsLog(null, userDo1.getId(), data1, new Date()));
//                }
//                System.out.println(noticeList);
//                noticeDao.saveAll(noticeList);
//
//            }
//            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
//            return true;
//
//        }catch (Exception e){
//            e.printStackTrace();
//            return false;
//        }
//
//    }
    private Notice transform(Notice notice){
        Notice notice1 = new Notice();
        notice1.setTitle(notice.getTitle());
        notice1.setAddressee(notice.getAddressee());
        notice1.setDeadline(notice.getDeadline());
        notice1.setFileList(notice.getFileList());
        notice1.setMessage(notice.getMessage());
        notice1.setNote(notice.getNote());
        notice1.setSender(notice.getSender());
        notice1.setStatus(notice.getStatus());
        notice1.setUpdateTime(notice.getUpdateTime());
        notice1.setType(notice.getType());
        notice1.setUnit(notice.getUnit());
        return notice1;
    }

    @Override
    @Transactional
    public boolean updateNotice(Notice notice) {
        try{
            notice.setStatus(0);
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Transactional
    public Notice getNotice(int id) {
        try {
            Notice notice = noticeDao.findById(id);
            notice.setStatus(1);
            noticeDao.save(notice);
            String userId = "";

            if (notice.getType() == 0){
                //已接收
                userId = notice.getAddressee();
            }else {
                userId = notice.getSender();
            }
            UserDo userDo = userService.findById(userId); // 发送人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "查看了关于[" + notice.getTitle() + "的通知";
            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));

            UserDo addressee = userService.findById(notice.getAddressee());
            Addressee addressee1 = new Addressee();
            addressee1.setId(addressee.getId());
            addressee1.setName(addressee.getName());
            String json = JSONObject.toJSONString(addressee1);
            notice.setAddressee(json);

            return notice;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    public Paging<Notice> getReceiveList(String user, int type, int pageNum, int pageSize) {
        try{
            Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
            Page<Notice> p;

            if (type == 0){
                //已接收
                p = noticeDao.findOutByAddresseeLikeAndType("%"+user+"%", type, pageable);
            }else {
                //已发送，草稿
                p = noticeDao.findOutBySenderAndType(user, type, pageable);
            }

//        for (Notice notice:p.getContent()){
//            String addresseeId = "";//收件人编号
//            UserDo addressee = new UserDo();//收件人实体
//            for (int i = 0; i < p.getContent().size(); i++){
//                List<Addressee> addressees = new ArrayList<>();
//                Notice notice = p.getContent().get(i);
//                if (i == 0) {
//                    addresseeId = notice.getAddressee().split(",")[0];
//                    addressee = userService.findById(addresseeId);
//                }else {
//                    String addresseeId1 = notice.getAddressee().split(",")[0];
//                    if (!addresseeId.equals(addresseeId1)){
//                        //如果两个收件人不一样，重新获取user
//                        addressee = userService.findById(addresseeId1);
//                    }
//                }
//
//                Addressee addressee1 = new Addressee();
//                addressee1.setId(addressee.getId());
//                addressee1.setName(addressee.getName());
//                addressees.add(addressee1);
//                String json = JSONObject.toJSONString(addressees);
//                notice.setAddressee(json);
//            }


            Paging<Notice> paging = new Paging<>();
            paging.setData(p.getContent());
            paging.setPageSize(pageSize);
            paging.setPageNum(pageNum);
            paging.setTotal((int)p.getTotalElements());
            return paging;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }


    }

    @Override
    @Transactional
    public boolean updateStatus(List<Notice> notices) {
        try {
            String userId = "";
            if (notices.get(0).getType() == 0){
                String str = notices.get(0).getAddressee();
                List<Addressee> addresseeList = JSONArray.parseArray(str,Addressee.class);
                userId = addresseeList.get(0).getId();
            }else {
                userId = notices.get(0).getSender();
            }
            UserDo userDo = userService.findById(userId); // 当前登录人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "修改";
            for (Notice notice:notices){
                notice.setStatus(1);
                noticeDao.save(notice);
                data = data + "[" + notice.getTitle() + "]";
            }
            data = data + "为已读";


            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Notice> findBySender(String userId, int status, int type) {
        try{
            return noticeDao.findOutByStatusAndType(status, type);
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }


}
