package com.zjty.efs.user.subject.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-23
 */
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@AutoDocument
@ApiModel(value = "用户", description = "用户实体类")
@Table(name = "user")
public class UserDo {

    @ApiModelProperty(value = "id",example = "jksdhfjks5")
    @Id
    @GeneratedValue(generator = "uuid2")
    @GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator" )
    private String id;

    @ApiModelProperty(value = "用户姓名",example = "mcj")
    private String name;

    @ApiModelProperty(value = "联系方式（固定电话）",example = "0571-123456")
    private String tel;

    @ApiModelProperty(value = "联系方式（手机）",example = "113665465465")
    private String phone;

    @ApiModelProperty(value = "联系方式（短号）",example = "123")
    private String cornet;

    @ApiModelProperty(value = "备注", example = "dadsd")
    private String remark;

    @ApiModelProperty(value = "用户名", example = "zhangsan")
    private String account;

    @ApiModelProperty(value = "部门/处室", example = "秘书处")
    private String department;

    @ApiModelProperty(value = "密码",example = "password")
    private String password;

    @ApiModelProperty(value = "用户锁定状态,0_正常,1_冻结",example = "1")
    private Integer status;

    @ApiModelProperty(value = "单位", example = "A单位")
    private String unit;

    @ApiModelProperty(value = "数据更新时间", example = "2019-01-01 00:00:00.000")
    @JsonFormat(pattern = "yyyy:HH:dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
}
