package com.zjty.efs.bus.service;

import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Paging;

import java.util.List;

public interface AttentionService {
    /**
     * 获取消息提醒列表
     * @param userId 当前登录用户编号
     * @param pageNum 页码
     * @param pageSize 　每页条数
     * @return List<Paging></>
     */
    Paging<Attention> getAttentionList(String userId, int pageNum, int pageSize);

    /**
     * 添加消息提醒
     * @param attention 消息提醒实体
     * @return
     */
    boolean addAttention(Attention attention);

    /**
     * 修改消息提醒为已读
     * @param attentions　消息提醒实体列表
     * @return
     */
    boolean updateStatus(List<Attention> attentions);

    /**
     * 消息提醒红点
     * @param userId 当前登录用户编号
     * @return
     */
    boolean getRedDot(String userId);
}
