package com.zjty.efs.bus.util;

import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.service.AttentionService;
import com.zjty.efs.bus.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component
public class Job {
    @Autowired
    NoticeService noticeService;
    @Autowired
    AttentionService attentionService;
    @Scheduled(cron = "0 0 10 * * ? ")
    public void cronJob() {
        List<Notice> noticeList = noticeService.findBySender("",0,0);
        Date now = new Date();
        String data = "";
        for(Notice notice:noticeList){
            Attention attention = new Attention();
            Date endTime = notice.getDeadline();

            long days = (endTime.getTime()-now.getTime())/(1000*3600*24);
            System.out.println(days);
            if (days == 3 || days == 1){
                data = "您收到来自[" + notice.getSender() +"]的[" + notice.getTitle() + "],还有" + days +"天失效。";
                attention.setData(data);
                attention.setNoticeId(notice.getId());
                attention.setUserId(notice.getAddressee());
                attention.setStatus(0);
                attention.setUpdateTime(new Date());
                attentionService.addAttention(attention);
            }

        }
    }

}
