package com.zjty.efs.ftp.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@AutoDocument
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "DownLoadRequest",description = "文件下载次数请求")
public class DownLoadRequest {
    @ApiModelProperty(name = "userId",value = "用户id",notes = "用户id",example = "0f46770d-b602-4a80-bdec-a12978022625")
    private String userId;//用户id
    @ApiModelProperty(name = "fileIds",value = "文件id集合",notes = "文件id集合",example = "[1,2]")
    private List<Integer> fileIds;//文件id集合
}
