package com.zjty.efs.bus.controller;

import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

@AutoDocument
@Api(tags = "提醒接口")
@RestController
@RequestMapping("/attention")
public class AttentionController {
    @ApiOperation(value = "获取提醒列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前登录用户", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageNum", value = "页码", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "条数", dataType = "int", paramType = "query", required = true)
    })
    @PostMapping("/getAttention")
    public ResponseEntity<Paging<Attention>> test(@RequestParam int userId, int pageNum, int pageSize){
        return ResponseEntity.ok(new Paging<>());
    }

}
