package com.zjty.efs.bus.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.lang.annotation.Documented;

@AutoDocument
@ApiModel(value = "提醒", description = "提醒实体类")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table(name = "attention")
public class Attention {
    /**
     * id
     */
    @ApiModelProperty(value = "id", example = "1")
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private int id;

    /**
     * 标题
     */
    @ApiModelProperty(value = "data", example = "您收到来自XX单位的文件，请及时查收。", dataType = "String", name = "提醒内容")
    @Column(name = "data")
    private String data;

    /**
     * 通知编号
     */
    @ApiModelProperty(value = "noticeId", example = "1", dataType = "int", name = "通知编号")
    @Column(name = "notice_id")
    private int noticeId;

    /**
     * 当前用户
     */
    @ApiModelProperty(value = "userId", example = "1", dataType = "int", name = "当前用户编号")
    @Column(name = "user_id")
    private int userId;

}
