package com.zjty.efs.bus.service.impl;

import com.zjty.efs.bus.Dao.AttentionDao;
import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.AttentionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class AttentionServiceImpl implements AttentionService {
    @Autowired
    AttentionDao attentionDao;
    @Override
    public Paging<Attention> getAttentionList(int userId, int pageNum, int pageSize) {
        try {
            Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
            Page<Attention> p = attentionDao.findOutByUserId(userId, pageable);

            Paging<Attention> paging= new Paging<>();
            paging.setTotal((int)p.getTotalElements());
            paging.setPageNum(pageNum);
            paging.setPageSize(pageSize);
            paging.setData(p.getContent());
            return paging;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    public boolean addAttention(int noticeId){

        return true;
    }
}
