package com.zjty.efs.bus.service.impl;

import com.zjty.efs.bus.Dao.NoticeDao;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class NoticeServiceImpl implements NoticeService {
    @Autowired
    NoticeDao noticeDao;
    @Override
    public boolean addNotice(Notice notice) {
        try{
            noticeDao.save(notice);

            Notice notice1 = new Notice();
            notice1.setType(0);
            notice1.setTitle(notice.getTitle());
            notice1.setAddressee(notice.getAddressee());
            notice1.setDeadline(notice.getDeadline());
            notice1.setFileList(notice.getFileList());
            notice1.setMessage(notice.getMessage());
            notice1.setNote(notice.getNote());
            notice1.setSender(notice.getSender());
            notice1.setStatus(notice.getStatus());
            notice1.setUpdateTime(notice.getUpdateTime());
            noticeDao.save(notice1);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public boolean updateNotice(Notice notice) {
        try{
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Notice getNotice(int id) {
        try {
            Notice notice = noticeDao.findById(id);
            notice.setStatus(1);
            noticeDao.save(notice);
            return notice;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    public Paging<Notice> getReceiveList(int user, int type, int pageNum, int pageSize) {

        Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
        Page<Notice> p = noticeDao.findOutBySenderAndType(user, type, pageable);
        Paging<Notice> paging = new Paging<>();
        paging.setData(p.getContent());
        paging.setPageSize(pageSize);
        paging.setPageNum(pageNum);
        paging.setTotal((int)p.getTotalElements());
        return paging;
    }

    @Override
    public boolean updateStatus(List<Notice> notices) {
        try {
            for (Notice notice:notices){
                noticeDao.save(notice);
            }
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Notice> findBySender(int userId, int status, int type) {
        try{
            return noticeDao.findOutBySenderAndStatusAndType(userId, status, type);
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }


}
